---
title: SSRF vulnerability in @opennextjs/cloudflare proactively mitigated for
  all Cloudflare customers · Changelog
description: Mitigations have been put in place for all existing and future
  deployments of sites with the Cloudflare adapter for Open Next in response to
  an identified Server-Side Request Forgery (SSRF) vulnerability in the
  @opennextjs/cloudflare package
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-06-17-open-next-ssrf/
  md: https://developers.cloudflare.com/changelog/2025-06-17-open-next-ssrf/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## SSRF vulnerability in @opennextjs/cloudflare proactively mitigated for all Cloudflare customers

Jun 17, 2025

[Workers](https://developers.cloudflare.com/workers/)

Mitigations have been put in place for all existing and future deployments of sites with the Cloudflare adapter for Open Next in response to an identified Server-Side Request Forgery (SSRF) vulnerability in the `@opennextjs/cloudflare` package.

The vulnerability stemmed from an unimplemented feature in the Cloudflare adapter for Open Next, which allowed users to proxy arbitrary remote content via the `/_next/image` endpoint.

This issue allowed attackers to load remote resources from arbitrary hosts under the victim site's domain for any site deployed using the Cloudflare adapter for Open Next. For example: `https://victim-site.com/_next/image?url=https://attacker.com`. In this example, attacker-controlled content from `attacker.com` is served through the victim site's domain (`victim-site.com`), violating the same-origin policy and potentially misleading users or other services.

References: <https://www.cve.org/cverecord?id=CVE-2025-6087>, <https://github.com/opennextjs/opennextjs-cloudflare/security/advisories/GHSA-rvpw-p7vw-wj3m>

#### Impact

* SSRF via unrestricted remote URL loading
* Arbitrary remote content loading
* Potential internal service exposure or phishing risks through domain abuse

#### Mitigation

The following mitigations have been put in place:

**Server side updates** to Cloudflare's platform to restrict the content loaded via the `/_next/image` endpoint to images. The update automatically mitigates the issue for all existing and any future sites deployed to Cloudflare using the affected version of the Cloudflare adapter for Open Next

**Root cause fix:** Pull request [#727](https://github.com/opennextjs/opennextjs-cloudflare/pull/727) to the Cloudflare adapter for Open Next. The patched version of the adapter has been released as `@opennextjs/cloudflare@1.3.0`

**Package dependency update:** Pull request [cloudflare/workers-sdk#9608](https://github.com/cloudflare/workers-sdk/pull/9608) to create-cloudflare (c3) to use the fixed version of the Cloudflare adapter for Open Next. The patched version of create-cloudflare has been published as `create-cloudflare@2.49.3`.

In addition to the automatic mitigation deployed on Cloudflare's platform, we encourage affected users to upgrade to `@opennext/cloudflare` v1.3.0 and use the [`remotePatterns`](https://nextjs.org/docs/pages/api-reference/components/image#remotepatterns) filter in Next config if they need to allow-list external urls with images assets.
