---
title: Add HEX timestamp to a request header · Cloudflare Rules docs
description: Add a custom header to requests sent to the origin server with the
  current timestamp in hexadecimal format for debugging, tracking, or custom
  routing purposes.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Headers,Request modification
source_url:
  html: https://developers.cloudflare.com/rules/snippets/examples/hex-timestamp/
  md: https://developers.cloudflare.com/rules/snippets/examples/hex-timestamp/index.md
---

```js
export default {
  async fetch(request) {
    // Get the current timestamp
    const timestamp = Date.now();


    // Convert the timestamp to hexadecimal format
    const hexTimestamp = timestamp.toString(16);


    // Clone the request and add the custom header
    const modifiedRequest = new Request(request, {
      headers: new Headers(request.headers),
    });
    modifiedRequest.headers.set("X-Hex-Timestamp", hexTimestamp);


    // Log the custom header for debugging
    console.log(`X-Hex-Timestamp: ${hexTimestamp}`);


    // Pass the modified request to the origin
    const response = await fetch(modifiedRequest);


    return response;
  },
};
```
