---
title: Cloudflare 1xxx errors · Cloudflare Support docs
description: The errors covered in this document may occur when accessing a
  website proxied by Cloudflare. For issues related to the Cloudflare API or
  dashboard, refer to our Cloudflare API documentation.
lastUpdated: 2025-05-28T15:52:59.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/index.md
---

The errors covered in this document may occur when accessing a website proxied by Cloudflare. For issues related to the Cloudflare API or dashboard, refer to our [Cloudflare API documentation](https://developers.cloudflare.com/api/).

HTTP errors such as `409`, `530`, `403`, and `429` are returned in the HTTP status header of a response, while 1XXX errors appear in the HTML body of the response.

Customize error pages

Refer to [Custom Errors](https://developers.cloudflare.com/rules/custom-errors/) for instructions on customizing the default error pages discussed in this article.

### Support and assistance

If the suggested resolutions for each error do not resolve the issue, contact [Cloudflare Support](https://developers.cloudflare.com/support/contacting-cloudflare-support/).

* Only the website owner can contact Cloudflare for technical support. You can find a domain's contact details via the [Whoisdatabase](https://lookup.icann.org/).
* Pro, Business and Enterprise plan users have access to email support.
* Business and Enterprise users can also access chat support.
* For additional support options, refer to the [Cloudflare plans](https://www.cloudflare.com/plans/).

## Error 1000: DNS points to prohibited IP

For a complete description of this error refer to the [Error 1000](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1000/) page.

## Error 1001: DNS resolution error

For a complete description of this error refer to the [Error 1001](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1001/) page.

## Error 1002: DNS points to Prohibited IP

For a complete description of this error refer to the [Error 1002: DNS points to Prohibited IP](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1002/#error-1002-dns-points-to-prohibited-ip) page.

## Error 1002: Restricted

For a complete description of this error refer to the [Error 1002: Restricted](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1002/#error-1002-restricted) page.

## Error 1003 Access Denied: Direct IP Access Not Allowed

For a complete description of this error refer to the [Error 1003](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1003/) page.

## Error 1004: Host Not Configured to Serve Web Traffic

For a complete description of this error refer to the [Error 1004](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1004/) page.

## Errors 1005 Access Denied: Autonomous System Number (ASN) banned

For a complete description of this error refer to the [Error 1005](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1005/) page.

## Errors 1006, 1007, 1008 or 1106 Access Denied: Your IP address has been banned

For a complete description of this error refer to the [Error 1006, 1007, 1008 or 1106](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1006/) page.

## Errors 1009 Access Denied: Country or region banned

For a complete description of this error refer to the [Error 1009](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1009/) page.

## Error 1010: The owner of this website has banned your access based on your browser's signature

For a complete description of this error refer to the [Error 1010](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1010/) page.

## Error 1011: Access Denied (Hotlinking Denied)

For a complete description of this error refer to the [Error 1011](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1011/) page.

## Error 1012: Access Denied

For a complete description of this error refer to the [Error 1012](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1012/) page.

## Error 1013: HTTP hostname and TLS SNI hostname mismatch

For a complete description of this error refer to the [Error 1013](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1013/) page.

## Error 1014: CNAME Cross-User Banned

For a complete description of this error refer to the [Error 1014](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1014/) page.

## Error 1015: You are being rate limited

For a complete description of this error refer to the [Error 1015](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1015/) page.

## Error 1016: Origin DNS error

For a complete description of this error refer to the [Error 1016](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1016/) page.

## Error 1018: Could not find host

For a complete description of this error refer to the [Error 1018](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1018/) page.

## Error 1019: Compute server error

For a complete description of this error refer to the [Error 1019](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1019/) page.

## Error 1020: Access denied

For a complete description of this error refer to the [Error 1020](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1020/) page.

## Error 1023: Could not find host

For a complete description of this error refer to the [Error 1023](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1023/) page.

## Error 1025: Please check back later

For a complete description of this error refer to the [Error 1025](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1025/) page.

## Error 1033: Argo Tunnel error

For a complete description of this error refer to the [Error 1033](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1033/) page.

## Error 1034: Edge IP Restricted

For a complete description of this error refer to the [Error 1034](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1034/) page.

## Error 1035: Invalid request rewrite (invalid URI path)

For a complete description of this error refer to the [Error 1035](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1035/) page.

## Error 1036: Invalid request rewrite (maximum length exceeded)

For a complete description of this error refer to the [Error 1036](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1036/) page.

## Error 1037: Invalid rewrite rule (failed to evaluate expression)

For a complete description of this error refer to the [Error 1037](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1037/) page.

## Error 1040: Invalid request rewrite (header modification not allowed)

For a complete description of this error refer to the [Error 1040](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1040/) page.

## Error 1041: Invalid request rewrite (invalid header value)

For a complete description of this error refer to the [Error 1041](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1041/) page.

## Error 1101: Rendering error

For a complete description of this error refer to the [Error 1101](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1101/) page.

## Error 1102: Rendering error

For a complete description of this error refer to the [Error 1102](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1102/) page.

## Error 1104: A variation of this email address is already taken in our system. Only one variation is allowed.

For a complete description of this error refer to the [Error 1104](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1104/) page.

## Error 1200: Cache connection limit

For a complete description of this error refer to the [Error 1200](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1200/) page.
